[ env.ini ]
set var=CONF_REGION value="tr(1,World)"
set var=CONF_PROVIDER value="tr(2,Expert)"
set var=CONF_DESCRIPTION value="tr(3,Routed Ethernet Packet Service configuration.)"
set var=CONF_SERVICE value="tr(4,Routed Ethernet - NAPT - DHCP)"
set var=CONF_DATE value=""
set var=CONF_TPVERSION value=1.2.0
set var=HOST_SETUP value=auto
set var=UPGRADE_URL value=http://www.speedtouch.com/upgrade500.htm
set var=ATM_addr value="8.35"

[ wizard.ini ]
' ATM=PVC
'--------
def var=ATM type=grp desc="tr(5,Specify the details of the Routed Ethernet Packet Service. All information should be provided by your ISP.)" alias="tr(6,Routed Ethernet Packet Service)"
def var=ATM_addr type=combo grp=ATM alias="VPI/VCI" data="0.32,0.33,0.35,0.36,0.37,0.38,0.100,1.32,1.33,1.100,8.35,8.36,8.37,8.48,8.81" desc="tr(7,Choose a VPI/VCI from the list)" default=8.35
' IP=Settings
'------------
def var=IP type=grp desc="tr(8,Specify the details of the Routed Ethernet Account. All information should be provided by your ISP.)" alias="tr(9,Routed Ethernet Account Settings)"
def var=IP_addr type=ipaddr grp=IP alias="tr(10,WAN IP address)" req=no desc="tr(11,Enter the WAN IP Address.)"
def var=IP_mask type=ipmask grp=IP alias="tr(12,WAN IP netmask)" req=no desc="tr(13,Enter the WAN IP Netmask.)"
def var=IP_auto type=bool grp=IP alias="tr(14,Auto-configured)" data="no,yes"
'ST Security
'-----------
def var=ST type=grp desc="tr(15,Specify user name and password to protect SpeedTouch administrative access.)" alias="tr(16,SpeedTouch Security)"
def var=%ST_SYS_USERNAME type=string grp=ST alias="tr(17,User Name)" desc="tr(18,Enter user name.)"
def var=%ST_SYS_PASSWORD type=passw grp=ST alias="tr(19,Password)" desc="tr(20,Enter your password.)" max=32
def var=dummy type=passwcheck grp=ST alias="tr(21,Confirm Password)" desc="tr(22,Re-enter your password)" linkvar=%ST_SYS_PASSWORD max=32

[ hostwizard.ini ]

[ phone.ini ]
add name=USB addr=usb.0.35 type=any logging=off
add name=PVC_1 addr=$ATM_addr type=any

[ bridge.ini ]
ifadd intf=USB dest=USB logging=off
ifattach intf=USB logging=off
config age=300 filter=no_WAN_broadcast

[ pptp.ini ]

[ dhcp.ini ]
config autodhcp=on scantime=10 state=enabled trace=off
policy verifyfirst=on trustclient=on
pool add name=LAN_private
pool config name=LAN_private poolstart=10.0.0.1 poolend=10.0.0.254 netmask=255.255.255.0 gateway=10.0.0.138 leasetime=7200

[ ethoa.ini ]
ifadd intf=ETHoA_1 dest=PVC_1
ifattach intf=ETHoA_1

[ ipoa.ini ]

[ pppoa.ini ]

[ pppoe.ini ]

[ pppoerelay.ini ]

[ cip.ini ]

[ ip.ini ]
#if IP_auto=yes
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0
#else
config forwarding=on firewalling=on redirects=on sourcerouting=off netbroadcasts=off ttl=64 fraglimit=64 defragmode=always addrcheck=dynamic mssclamping=on
apadd addr=10.0.0.138/24 intf=eth0 addroute=yes type=1
ifconfig intf=loop mtu=1500 group=local linksensing=off
ifconfig intf=eth0 mtu=1500 group=lan linksensing=off
rtadd dst=255.255.255.255/32 gateway=10.0.0.138
rtadd dst=224.0.0.0/4 intf=eth0
apadd addr=$IP_addr netmask=$IP_mask intf=ETHoA_1 addrtrans=pat addroute=yes
rtadd dst=0.0.0.0/0 gateway=$IP_addr
#endif

[ dhcr.ini ]
ifconfig intf=eth0 relay=on
add addr=127.0.0.1 intf=eth0 giaddr=10.0.0.138

[ dhcc.ini ]
#if IP_auto=yes
config trace=off
ifadd intf=ETHoA_1
ifconfig intf=ETHoA_1 hostname="SpeedTouch" addrtrans=pat dns=on gateway=on metric=1
ifattach intf=ETHoA_1
#else
config trace=off
#endif

[ autopvc.ini ]
config mode=passive type=bridge

[ system.ini ]
config upnp=enabled mdap=enabled dcache=enabled drst=enabled
#if $%ST_SYS_PASSWORD=""
setpassword password="" userid=$%ST_SYS_USERNAME
#else
setpassword password=$%ST_SYS_PASSWORD userid=$%ST_SYS_USERNAME
#endif

[ upnp.ini ]
config defcservice=ETHoA_1

[ language.ini ]
langdef lang=nl charset=ISO-8859-1
t r="1, Wereld"
t r="2, Expert"
t r="3, Configuratie met routed-Ethernet Packet-service."
t r="4, Routed Ethernet - NAPT - DHCP"
t r="5, Geef de details van de routed-Ethernet Packet-service op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="6, Routed-Ethernet Packet-service"
t r="7, Selecteer een VPI/VCI uit de lijst"
t r="8, Geef de details van de routed-Ethernet-account op. Alle informatie wordt door uw Internet-provider verstrekt."
t r="9, Instellingen van routed-Ethernet-account"
t r="10, Extern IP-adres"
t r="11, Geeft het extern IP-adres in."
t r="12, Netmasker"
t r="13, Geef netmasker van het extern IP address in."
t r="14, Automatische configuratie"
t r="15, Geef de gebruikersnaam en het wachtwoord op waarmee u het beheer van de SpeedTouch wilt beveiligen."
t r="16, SpeedTouch-beveiliging"
t r="17, Gebruikersnaam"
t r="18, Geef uw gebruikersnaam in."
t r="19, Wachtwoord"
t r="20, Geef uw wachtwoord in."
t r="21, Wachtwoord bevestigen"
t r="22, Geef uw wachtwoord nogmaals in"
langdef lang=fr charset=ISO-8859-1
t r="1, Monde"
t r="2, Expert"
t r="3, Configuration du service de transmission par paquets Ethernet rout."
t r="4, Ethernet rout, DHCP, NAPT"
t r="5, Spcifiez les dtails relatifs au service de transmission par paquets Ethernet rout. Toutes ces informations doivent tre fournies par votre FAI."
t r="6, Service de transmission par paquets Ethernet rout"
t r="7, Slectionnez un VPI/VCI dans la liste"
t r="8, Spcifiez les dtails relatifs au compte de la connexion Ethernet route. Toutes ces informations doivent tre fournies par votre FAI."
t r="9, Paramtres du compte de la connexion Ethernet route"
t r="10, Adresse IP de rseau tendu (WAN)"
t r="11, Entrez l'adresse IP du WAN."
t r="12, Masque de rseau IP du WAN"
t r="13, Entrez le masque de rseau IP du WAN."
t r="14, Auto-configur"
t r="15, Indiquez un nom d'utilisateur et un mot de passe pour protger l'accs administratif de SpeedTouch."
t r="16, Scurit SpeedTouch"
t r="17, Nom d'utilisateur"
t r="18, Entrez un nom d'utilisateur."
t r="19, Mot de passe"
t r="20, Entrez votre mot de passe."
t r="21, Confirmer le mot de passe"
t r="22, Entrez  nouveau le mot de passe"
langdef lang=de charset=ISO-8859-1
t r="1, Welt"
t r="2, Expert"
t r="3, Konfiguration des Routed Ethernet-Paketdienstes."
t r="4, Routed Ethernet - NAPT - DHCP"
t r="5, Geben Sie die Einzelheiten zum Routed Paketdienst an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="6, Routed Ethernet Paketdienst"
t r="7, Whlen Sie einen VPI/VCI-Eintrag aus der Liste aus"
t r="8, Geben Sie die Einzelheiten zum Routed Ethernet-Konto an. Ihr Internetdienstanbieter kann Ihnen alle Informationen bereitstellen."
t r="9, Einstellungen fr das Routed Ethernet-Konto"
t r="10, WAN-IP-Adresse"
t r="11, Geben Sie die WAN-IP-Adresse ein."
t r="12, WAN-IP-Subnetzmaske"
t r="13, Geben Sie die WAN-IP-Subnetzmaske ein."
t r="14, Automatisch konfiguriert"
t r="15, Geben Sie den Benutzernamen und das Kennwort an, um den Administratorzugriff auf das SpeedTouch zu schtzen."
t r="16, SpeedTouch Sicherheit"
t r="17, Benutzername"
t r="18, Geben Sie den Benutzernamen ein."
t r="19, Kennwort"
t r="20, Geben Sie das Kennwort ein."
t r="21, Kennwort besttigen"
t r="22, Geben Sie das Kennwort erneut ein."
langdef lang=it charset=ISO-8859-1
t r="1, Mondo"
t r="2, Esperta"
t r="3, Configurazione per la trasmissione di pacchetti in modalit routed Ethernet."
t r="4, Routed Ethernet - NAPT - DHCP"
t r="5, Specificare i dettagli del Routed Ethernet Packet Service. Tutte le informazioni devono essere fornite dall'ISP."
t r="6, Routed Ethernet Packet Service"
t r="7, Scegliere un VPI/VCI dall'elenco"
t r="8, Specificare i dettagli dell'account routed Ethernet. Tutte le informazioni devono essere fornite dall'ISP."
t r="9, Impostazioni account routed Ethernet"
t r="10, Indirizzo IP WAN"
t r="11, Immettere l'indirizzo IP WAN."
t r="12, Subnet mask IP WAN"
t r="13, Immettere la subnet mask IP WAN."
t r="14, Autoconfigurato"
t r="15, Specificare un nome utente e una password per proteggere l'accesso amministrativo dello SpeedTouch."
t r="16, Sicurezza SpeedTouch"
t r="17, Nome utente"
t r="18, Immettere il nome utente."
t r="19, Password"
t r="20, Immettere la password."
t r="21, Conferma password"
t r="22, Immettere nuovamente la password."
langdef lang=pt charset=ISO-8859-1
t r="1, Mundo"
t r="2, Avanado"
t r="3, Configurao do Servio de Pacote da Ethernet Roteada."
t r="4, Ethernet roteada - NAPT - DHCP"
t r="5, Especifique os detalhes do Servio de Pacote do PPP Roteado. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="6, Servio de Pacote do PPP Roteado"
t r="7, Escolha um VPI/VCI na lista"
t r="8, Especifique os detalhes da Conta da Ethernet Roteada. Todas as informaes devem ser fornecidas pelo seu ISP."
t r="9, Configuraes do Conta da Ethernet Roteada"
t r="10, Endereo IP da Rede de comunicao expandida (Wide Area Network - WAN)"
t r="11, Insira o Endereo IP da WAN."
t r="12, Mscara de rede IP da WAN"
t r="13, Insira a mscara de rede IP da WAN."
t r="14, Auto configurado"
t r="15, Especifique o nome do usurio e a senha para proteger o acesso administrativo do SpeedTouch."
t r="16, Segurana do SpeedTouch"
t r="17, Nome do usurio"
t r="18, Digite o nome do usurio."
t r="19, Senha"
t r="20, Digite sua senha."
t r="21, Confirme a senha"
t r="22, Digite novamente sua senha"
langdef lang=es charset=ISO-8859-1
t r="1, Mundial"
t r="2, Experto"
t r="3, Configuracin de servicios de paquetes Ethernet enrutados."
t r="4, Ethernet enrutada; NAPT; DHCP"
t r="5, Indique los detalles de los servicios de paquetes Ethernet enrutados. Toda la informacin debe proporcionarla el ISP."
t r="6, Servicios de paquetes Ethernet enrutados"
t r="7, Elija un identificador VPI/VCI de la lista"
t r="8, Indique los detalles de la cuenta Ethernet enrutada. Toda la informacin debe proporcionarla el ISP."
t r="9, Configuracin de cuentas Ethernet enrutadas"
t r="10, Direccin IP de WAN"
t r="11, Escriba la direccin IP de WAN."
t r="12, Mscara de red IP de WAN"
t r="13, Escriba la mscara de red IP de WAN."
t r="14, Configurado automticamente"
t r="15, Indique el nombre de usuario y la contrasea para proteger el acceso administrativo a SpeedTouch."
t r="16, Seguridad de SpeedTouch"
t r="17, Nombre de usuario"
t r="18, Escriba el nombre de usuario."
t r="19, Contrasea"
t r="20, Escriba la contrasea."
t r="21, Confirme la contrasea"
t r="22, Vuelva a escribir la contrasea"
langdef lang=sv charset=ISO-8859-1
t r="1, Vrld"
t r="2, Expert"
t r="3, Konfiguration fr Routed Ethernet Packet Service."
t r="4, Routed Ethernet - NAPT - DHCP"
t r="5, Ange information om Routed Ethernet Packet Service. Din ISP ska kunna ge all information."
t r="6, Routed Ethernet Packet Service"
t r="7, Vlj VPI/VCI frn listan"
t r="8, Ange information om kontot fr Routed Ethernet. Din ISP ska kunna ge all information."
t r="9, Kontoinstllningar fr Routed Ethernet"
t r="10, IP-adress fr WAN"
t r="11, Ange IP-adress fr WAN."
t r="12, IP-ntmask fr WAN"
t r="13, Ange IP-ntmask fr WAN."
t r="14, Autokonfigurerad"
t r="15, Ange anvndarnamn och lsenord fr att skydda administrativ tkomst till SpeedTouch."
t r="16, SpeedTouch-skerhet"
t r="17, Anvndarnamn"
t r="18, Ange anvndarnamn."
t r="19, Lsenord"
t r="20, Ange lsenord."
t r="21, Bekrfta lsenord"
t r="22, Ange ditt lsenord igen"

[ endofarch ]
